UniversalLoadSettingsEvent = {};
UniversalLoadSettingsEvent_mt = Class(UniversalLoadSettingsEvent, Event);
InitEventClass(UniversalLoadSettingsEvent, "UniversalLoadSettingsEvent");

UniversalLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX = 1;

---Create instance of Event class
function UniversalLoadSettingsEvent.emptyNew()
    local self = Event.new(UniversalLoadSettingsEvent_mt);
    return self;
end;

---Create new instance of event
function UniversalLoadSettingsEvent.new(minMax)
    local self = UniversalLoadSettingsEvent.emptyNew();
    self.minMax = minMax;
    return self;
end;

---Called on client side on join
function UniversalLoadSettingsEvent:readStream(streamId, connection)
    if g_server == nil then        
        self.minMax = streamReadInt8(streamId, UniversalLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
        
        self:run(connection);
    end;
end;

---Called on server side on join
function UniversalLoadSettingsEvent:writeStream(streamId, connection)
	if g_additionalContractTypes.settings["universalMission_minMax"] ~= nil then
		streamWriteInt8(streamId, g_additionalContractTypes.settings["universalMission_minMax"], UniversalLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
	end;	
end;

---Run action on receiving side
function UniversalLoadSettingsEvent:run(connection)
	if g_server ~= nil then
		g_server:broadcastEvent(UniversalLoadSettingsEvent.new(g_additionalContractTypes.settings["universalMission_minMax"]), false);				
		return;
	end;
	if self.minMax ~= nil then
		g_additionalContractTypes.typ["universalMission"]:setMaxNumInstance(self.minMax);			
	end;
end;


