--[[
Copyright (C) GtX (Andy), 2025

Author: GtX | Andy
Date: 27.04.2025
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

ConstructionBrushCustomFieldDialog = {}

ConstructionBrushCustomFieldDialog.MOD_NAME = g_currentModName
ConstructionBrushCustomFieldDialog.MOD_DIRECTORY = g_currentModDirectory

local ConstructionBrushCustomFieldDialog_mt = Class(ConstructionBrushCustomFieldDialog, YesNoDialog)

function ConstructionBrushCustomFieldDialog.register()
    local dialog = ConstructionBrushCustomFieldDialog.new()

    g_gui:loadGui(ConstructionBrushCustomFieldDialog.MOD_DIRECTORY .. "gui/ConstructionBrushCustomFieldDialog.xml", "ConstructionBrushCustomFieldDialog", dialog)

    -- if g_constructionScreenExtension ~= nil then
        -- g_constructionScreenExtension.customFieldDialog = dialog
    -- end

    ConstructionBrushCustomFieldDialog.INSTANCE = dialog
end

function ConstructionBrushCustomFieldDialog.show(callback, target, title, field, fieldPricePerSqm, groundPricePerSqm, fruitPricePerSqm)
    if ConstructionBrushCustomFieldDialog.INSTANCE == nil then
        ConstructionBrushCustomFieldDialog.register()

        return
    end

    local dialog = ConstructionBrushCustomFieldDialog.INSTANCE

    dialog:setTitle(title)
    dialog:setCallback(callback, target, nil)
    dialog:setFieldData(field, fieldPricePerSqm, groundPricePerSqm, fruitPricePerSqm)

    g_gui:showDialog("ConstructionBrushCustomFieldDialog")
end

function ConstructionBrushCustomFieldDialog.new(target, custom_mt)
    local self = YesNoDialog.new(target, custom_mt or ConstructionBrushCustomFieldDialog_mt)

    self.isButtonDisabled = false
    self.doEnterPress = false

    self.titleElementText = "Create Field"

    self.fruitTypeStateToIndex = {
        FruitType.UNKNOWN,
        FruitType.UNKNOWN
    }

    return self
end

function ConstructionBrushCustomFieldDialog.createFromExistingGui(gui, guiName)
    ConstructionBrushCustomFieldDialog.register()

    local callback = gui.callbackFunc
    local target = gui.target
    local title = gui.titleElementText

    local field = gui.field
    local fieldPricePerSqm = gui.fieldPricePerSqm
    local groundPricePerSqm = gui.groundPricePerSqm
    local fruitPricePerSqm = gui.fruitPricePerSqm

    ConstructionBrushCustomFieldDialog.show(callback, target, title, field, fieldPricePerSqm, groundPricePerSqm, fruitPricePerSqm)
end

function ConstructionBrushCustomFieldDialog:onOpen()
    ConstructionBrushCustomFieldDialog:superClass().onOpen(self)

    local fruitTypeStateToIndex = {
        FruitType.UNKNOWN,
        FruitType.UNKNOWN
    }

    local fruitTypesTexts = {
        g_i18n:getText("ui_growthMapPlowed"),
        g_i18n:getText("ui_growthMapCultivated")
    }

    local fruitTypesSorted = {}
    local fieldType = nil

    for _, fruitType in ipairs(g_fruitTypeManager:getFruitTypes()) do
        if fruitType.allowsSeeding then
            fieldType = fruitType.seedRequiredFieldType

            if fieldType == nil or fieldType == FieldType.DEFAULT then
                table.insert(fruitTypesSorted, {
                    index = fruitType.index,
                    title = fruitType.fillType.title or fruitType.name
                })
            end
        end
    end

    table.sort(fruitTypesSorted, function(a, b)
        return a.title < b.title
    end)

    for _, fruitType in ipairs(fruitTypesSorted) do
        table.insert(fruitTypeStateToIndex, fruitType.index)
        table.insert(fruitTypesTexts, fruitType.title)
    end

    self.fruitTypeStateToIndex = fruitTypeStateToIndex

    self.multiFruitTypes:setTexts(fruitTypesTexts)
    self.multiFruitTypes:setState(1, true)

    FocusManager:setFocus(self.multiFruitTypes)
end

function ConstructionBrushCustomFieldDialog:setTitle(title)
    self.titleElementText = title or ""
    ConstructionBrushCustomFieldDialog:superClass().setTitle(self, self.fillLevelLimiterTitle)
end

function ConstructionBrushCustomFieldDialog:setFieldData(field, fieldPricePerSqm, groundPricePerSqm, fruitPricePerSqm)
    self.field = field

    self.fieldPricePerSqm = fieldPricePerSqm or ConstructionBrushCustomField.FIELD_PRICE_PER_SQM
    self.groundPricePerSqm = groundPricePerSqm or ConstructionBrushCustomField.GROUND_PRICE_PER_SQM
    self.fruitPricePerSqm = fruitPricePerSqm or ConstructionBrushCustomField.FRUIT_PRICE_PER_SQM

    local fieldData = {
        valid = false,
        areaSqm = 0,
        farmlandId = 0,
        fieldCost = 0,
        fruitCost = 0,
        fruitTypeIndex = FruitType.UNKNOWN,
        groundTypeIndex = FieldGroundType.PLOWED
    }

    if field ~= nil and field.polygon ~= nil then
        local areaSqm = field.areaSqm

        if areaSqm == nil then
            areaSqm = field.polygon:getArea() or 0
        end

        fieldData.valid = true
        fieldData.areaSqm = areaSqm
        fieldData.polygon = field.polygon

        fieldData.fieldCost = areaSqm * self.fieldPricePerSqm
        fieldData.fruitCost = 0

        fieldData.totalCost = fieldData.fieldCost + fieldData.fruitCost

        local firstVertexX, firstVertexZ = field.polygon:getVertex(1)

        if firstVertexX ~= nil then
            fieldData.farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(firstVertexX, firstVertexZ)
        end
    end

    if self.textFarmlandId ~= nil then
        self.textFarmlandId:setText(fieldData.farmlandId)
    end

    if self.textFieldSize ~= nil then
        self.textFieldSize:setText(fieldData.areaSqm > 0 and g_i18n:formatArea(fieldData.areaSqm / 10000, 2) or "N/A")
    end

    if self.textFieldCost ~= nil then
        self.textFieldCost:setText(g_i18n:formatMoney(fieldData.fieldCost, 0, true, false))
    end

    if self.textCropTypeCost ~= nil then
        self.textCropTypeCost:setText(g_i18n:formatMoney(fieldData.fruitCost, 0, true, false))
    end

    self.callbackArgs = fieldData
end

function ConstructionBrushCustomFieldDialog:onClickFruitType(state)
    local fieldData = self.callbackArgs
    local hasFieldData = fieldData ~= nil

    local areaSqm = hasFieldData and fieldData.areaSqm or 0
    local fieldCost = hasFieldData and fieldData.fieldCost or 0

    local fruitCost = 0
    local totalCost = fieldCost

    local fruitTypeIndex = self.fruitTypeStateToIndex[state] or 0
    local groundTypeIndex = FieldGroundType.PLOWED

    if state > 1 then
        if state == 2 then
            fruitCost = areaSqm * self.groundPricePerSqm or ConstructionBrushCustomField.GROUND_PRICE_PER_SQM
            groundTypeIndex = FieldGroundType.CULTIVATED
        else
            fruitCost = areaSqm * self.fruitPricePerSqm or ConstructionBrushCustomField.FRUIT_PRICE_PER_SQM

            local fruitType = g_fruitTypeManager:getFruitTypeByIndex(fruitTypeIndex) or nil
            groundTypeIndex = fruitType ~= nil and fruitType:getDefaultSowingGroundType() or FieldGroundType.SOWN
        end

        totalCost = fieldCost + fruitCost
    end

    if self.titleCropTypeCost ~= nil then
        self.titleCropTypeCost:setText(g_i18n:getText(state > 2 and "contract_details_harvesting_crop" or "categoryType_soilPreparation") .. ":")
    end

    if self.textCropTypeCost ~= nil then
        self.textCropTypeCost:setText(g_i18n:formatMoney(fruitCost, 0, true, false))
    end

    if self.textTotalCost ~= nil then
        self.textTotalCost:setText(g_i18n:formatMoney(totalCost, 0, true, false))
    end

    if hasFieldData ~= nil then
        fieldData.fruitCost = fruitCost
        fieldData.totalCost = totalCost

        fieldData.fruitTypeIndex = fruitTypeIndex
        fieldData.groundTypeIndex = groundTypeIndex
    end
end
