--[[
Copyright (C) GtX (Andy), 2025

Author: GtX | Andy
Date: 27.04.2025
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

PlaceableCustomField = {}

PlaceableCustomField.MOD_NAME = g_currentModName
PlaceableCustomField.SPEC_NAME = string.format("%s.customField", g_currentModName)
PlaceableCustomField.SPEC_TABLE_NAME = string.format("spec_%s", PlaceableCustomField.SPEC_NAME)

PlaceableCustomField.NO_COST_PLACEMENT = false

local getCanFinish = PlaceableRiceField.getCanFinish
local getCanAddVertex = PlaceableRiceField.getCanAddVertex

function PlaceableCustomField.registerXMLPaths(schema, basePath)
    schema:setXMLSpecializationType("CustomField")

    schema:register(XMLValueType.FLOAT, basePath .. ".customField#fieldAreaPricePerSqm", "The price per square meter of field area drawn", "Default Value")
    schema:register(XMLValueType.FLOAT, basePath .. ".customField#groundTypePricePerSqm", "The price per square meter of field area when one of the ground types are selected", "Default Value")
    schema:register(XMLValueType.FLOAT, basePath .. ".customField#fruitTypePricePerSqm", "The price per square meter of field area when one of the fruit types are selected", "Default Value")
    schema:register(XMLValueType.BOOL, basePath .. ".customField#masterUserOnly", "When true fields can only be created by a Admin / Master User", false)

    schema:setXMLSpecializationType()
end

function PlaceableCustomField.prerequisitesPresent(specializations)
    if ConstructionBrushCustomField == nil then
        Logging.error("Brush class 'ConstructionBrushCustomField' is required for placeable specialisation 'PlaceableCustomField' but has failed to load!")

        return false
    end

    return not SpecializationUtil.hasSpecialization(PlaceableRiceFieldSpec or PlaceableRiceField, specializations)
end

function PlaceableCustomField.registerOverwrittenFunctions(placeableType)
    SpecializationUtil.registerOverwrittenFunction(placeableType, "playPlaceSound", PlaceableCustomField.playPlaceSound)
    SpecializationUtil.registerOverwrittenFunction(placeableType, "getNeedsSaving", PlaceableCustomField.getNeedsSaving)
end

function PlaceableCustomField.registerEventListeners(placeableType)
    SpecializationUtil.registerEventListener(placeableType, "onLoad", PlaceableCustomField)
    SpecializationUtil.registerEventListener(placeableType, "onDelete", PlaceableCustomField)
end

function PlaceableCustomField.registerFunctions(placeableType)
    SpecializationUtil.registerFunction(placeableType, "onCustomFieldAnswerEvent", PlaceableCustomField.onCustomFieldAnswerEvent)
    SpecializationUtil.registerFunction(placeableType, "createNewField", PlaceableCustomField.createNewField)
    SpecializationUtil.registerFunction(placeableType, "finalizeNewField", PlaceableCustomField.finalizeNewField)
    SpecializationUtil.registerFunction(placeableType, "addVertex", PlaceableCustomField.addVertex)
    SpecializationUtil.registerFunction(placeableType, "removeLastVertex", PlaceableCustomField.removeLastVertex)
    SpecializationUtil.registerFunction(placeableType, "getNumVertices", PlaceableCustomField.getNumVertices)
    SpecializationUtil.registerFunction(placeableType, "getCanAddVertex", PlaceableCustomField.getCanAddVertex)
    SpecializationUtil.registerFunction(placeableType, "getCanFinish", PlaceableCustomField.getCanFinish)
    SpecializationUtil.registerFunction(placeableType, "getFirstAndLastVertex", PlaceableCustomField.getFirstAndLastVertex)
    SpecializationUtil.registerFunction(placeableType, "getHasValidFields", PlaceableCustomField.getHasValidFields)
    SpecializationUtil.registerFunction(placeableType, "getCanCreateNewField", PlaceableCustomField.getCanCreateNewField)
    SpecializationUtil.registerFunction(placeableType, "getIsCustomField", PlaceableCustomField.getIsCustomField)
    SpecializationUtil.registerFunction(placeableType, "getCustomFieldMasterUserOnly", PlaceableCustomField.getCustomFieldMasterUserOnly)
    SpecializationUtil.registerFunction(placeableType, "getCustomFieldPricePerSqm", PlaceableCustomField.getCustomFieldPricePerSqm)
end

function PlaceableCustomField:onLoad()
    local spec = self[PlaceableCustomField.SPEC_TABLE_NAME]
    local xmlFile = self.xmlFile

    spec.isCancelling = false

    spec.guiTitle = g_i18n:getText("cse_createField", PlaceableCustomField.MOD_NAME)
    spec.creatingFieldMessage = g_i18n:getText("cse_creatingField", PlaceableCustomField.MOD_NAME)

    spec.fieldPricePerSqm = xmlFile:getValue("placeable.customField#fieldAreaPricePerSqm", ConstructionBrushCustomField.FIELD_PRICE_PER_SQM)
    spec.groundPricePerSqm = xmlFile:getValue("placeable.customField#groundTypePricePerSqm", ConstructionBrushCustomField.GROUND_PRICE_PER_SQM)
    spec.fruitPricePerSqm = xmlFile:getValue("placeable.customField#fruitTypePricePerSqm", ConstructionBrushCustomField.FRUIT_PRICE_PER_SQM)

    spec.masterUserOnly = xmlFile:getValue("placeable.customField#masterUserOnly", false)
end

function PlaceableCustomField:onDelete()
    g_messageCenter:unsubscribe(PlaceableCustomFieldAnswerEvent, self)
end

function PlaceableCustomField:onCustomFieldAnswerEvent(buildStatusCode, message)
    local spec = self[PlaceableCustomField.SPEC_TABLE_NAME]

    MessageDialog.hide()

    if spec.finalizeFieldCallback ~= nil then
        if buildStatusCode ~= PlaceableRiceField.BUILD_STATUS.OK then
            spec.isCancelling = true
            Logging.devError("PlaceableCustomField.onCustomFieldAnswerEvent - " .. message or "Cancelled")
        end

        spec.finalizeFieldCallback(buildStatusCode)
        spec.isCancelling = false
    end

    spec.finalizeFieldCallback = nil
end

function PlaceableCustomField:createNewField()
    return {
        node = nil,
        height = 0,
        areaSqm = 0,
        polygon = Polygon2D.new()
    }
end

function PlaceableCustomField:finalizeNewField(field, _, callback)
    local spec = self[PlaceableCustomField.SPEC_TABLE_NAME]

    local function onCancelledCallback(message)
        spec.isCancelling = true

        if callback ~= nil then
            callback(PlaceableRiceField.BUILD_STATUS.OK)
        end

        spec.isCancelling = false

        -- Logging.devInfo("PlaceableCustomField.finalizeNewField - " .. message or "Cancelled")

        return false
    end

    if field == nil or field.polygon == nil then
        return onCancelledCallback("Invalid field data")
    end

    local function dialogCallback(yes, fieldData)
        if not yes then
            return onCancelledCallback("Cancelled by user")
        end

        if fieldData == nil or not fieldData.valid then
            return onCancelledCallback("Invalid dialog field data")
        end

        if fieldData.totalCost ~= nil and fieldData.totalCost > 0 then
            if g_currentMission:getMoney() - fieldData.totalCost < 0 then
                g_currentMission:showBlinkingWarning(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"))

                return onCancelledCallback("Insufficient funds")
            end
        end

        local function updateCallback(dt, endTimeSec)
            if endTimeSec ~= nil and endTimeSec <= getTimeSec() then
                MessageDialog.hide()
            end
        end

        MessageDialog.show(spec.creatingFieldMessage, updateCallback, nil, DialogElement.TYPE_LOADING, false, getTimeSec() + 8)

        spec.isCancelling = false
        spec.finalizeFieldCallback = callback

        g_client:getServerConnection():sendEvent(PlaceableCustomFieldEvent.new(self, fieldData))
        g_messageCenter:subscribeOneshot(PlaceableCustomFieldAnswerEvent, self.onCustomFieldAnswerEvent, self)
    end

    field.title = spec.guiTitle
    field.areaSqm = field.polygon:getArea()
	
	local fieldPricePerSqm, groundPricePerSqm, fruitPricePerSqm = self:getCustomFieldPricePerSqm()

    ConstructionBrushCustomFieldDialog.show(dialogCallback, nil, spec.guiTitle, field, fieldPricePerSqm, groundPricePerSqm, fruitPricePerSqm)

    return true
end

function PlaceableCustomField:addVertex(field, x, z)
    local canAdd, message = self:getCanAddVertex(field, x, z)

    if canAdd then
        field.polygon:addPos(x, z)

        return true, nil
    end

    return false, message
end

function PlaceableCustomField:removeLastVertex(field)
    field.polygon:removeVertex(field.polygon:getNumVertices())
end

function PlaceableCustomField:getNumVertices(field)
    if field == nil or field.polygon == nil then
        return 0
    end

    return field.polygon:getNumVertices()
end

function PlaceableCustomField:getCanAddVertex(...)
    local oldMaxHeightDifference = PlaceableRiceField.MAX_HEIGHT_DIFF_TO_TERRAIN
    PlaceableRiceField.MAX_HEIGHT_DIFF_TO_TERRAIN = 1000000

    local canAdd, message = getCanAddVertex(self, ...)
    PlaceableRiceField.MAX_HEIGHT_DIFF_TO_TERRAIN = oldMaxHeightDifference

    return canAdd, message
end

function PlaceableCustomField:getCanFinish(...)
    return getCanFinish(self, ...)
end

function PlaceableCustomField:getFirstAndLastVertex(field)
    if field.polygon ~= nil then
        local numVertices = field.polygon:getNumVertices()

        if numVertices > 0 then
            local firstVertexX, firstVertexZ = field.polygon:getVertex(1)

            if numVertices == 1 then
                return firstVertexX, firstVertexZ, firstVertexX, firstVertexZ
            end

            local lastVertexX, lastVertexZ = field.polygon:getVertex(numVertices)

            return firstVertexX, firstVertexZ, lastVertexX, lastVertexZ
        end
    end

    return nil
end

function PlaceableCustomField:getHasValidFields()
    return false -- Only called by the brush during 'deactivate', return false so placeable is destroyed.
end

function PlaceableCustomField:getCanCreateNewField()
    return true -- Fields are not saved with the spec at this stage, required by brush only.
end

function PlaceableCustomField:getIsCustomField()
    return true
end

function PlaceableCustomField:getCustomFieldMasterUserOnly()
    local spec = self[PlaceableCustomField.SPEC_TABLE_NAME]

    return spec ~= nil and spec.masterUserOnly
end

function PlaceableCustomField:getCustomFieldPricePerSqm()
    if PlaceableCustomField.NO_COST_PLACEMENT then
		return 0, 0, 0, true
	end

	local spec = self[PlaceableCustomField.SPEC_TABLE_NAME]

    if spec ~= nil then
        return spec.fieldPricePerSqm, spec.groundPricePerSqm, spec.fruitPricePerSqm, false
    end

    return ConstructionBrushCustomField.FIELD_PRICE_PER_SQM, ConstructionBrushCustomField.GROUND_PRICE_PER_SQM, ConstructionBrushCustomField.FRUIT_PRICE_PER_SQM, false
end

function PlaceableCustomField:getNeedsSaving(superFunc)
    return false
end

function PlaceableCustomField:playPlaceSound(superFunc)
    local spec = self[PlaceableCustomField.SPEC_TABLE_NAME]

    if spec ~= nil and spec.isCancelling then
        return
    end

    superFunc(self)
end
