--[[
Part of Production Supply Trader FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]


--Gewählte Verpackung spawnen
function ProductionPoint:ReceiveBuySellEvent(fillTypeIndex, amount, buySell)
	local fillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)
	local currentFillLevel = self.storage:getFillLevel(fillTypeIndex)

	--true = kaufen
	if buySell == true then
		local maxStorage = self.storage:getFreeCapacity(fillTypeIndex)
		local pricePerLiter = fillType.pricePerLiter * 2 * EconomyManager.getPriceMultiplier()
		local currentMoney = g_currentMission:getMoney(self.ownerFarmId)

		--Prüfen ob genug Platz im Lager wäre, sonst anpassen
		if maxStorage < (currentFillLevel + amount) then
			amount = maxStorage
		end

		--Prüfen ob genug Geld vorhanden, sonst anpassen
		if currentMoney < (amount * pricePerLiter) then
			amount = math.round(currentMoney / pricePerLiter)
		end

		--Ins Lager schreiben, Geld abziehen
		self.storage:setFillLevel(currentFillLevel + amount, fillTypeIndex)
		g_currentMission:addMoney(-(amount * pricePerLiter), self.ownerFarmId, MoneyType.PURCHASE_PALLETS, true)
	else
		local maxStorage = self.storage:getFillLevel(fillTypeIndex)
		local pricePerLiter = fillType.pricePerLiter * EconomyManager.getPriceMultiplier() * ProductionPoint.DIRECT_SELL_PRICE_FACTOR

		--Prüfen ob genug im Lager ist, sonst anpassen
		if maxStorage < amount then
			amount = maxStorage
		end

		--Aus Lager entfernen, Geld gutschreiben
		self.storage:setFillLevel(currentFillLevel - amount, fillTypeIndex)
		g_currentMission:addMoney((amount * pricePerLiter), self.ownerFarmId, MoneyType.SOLD_PRODUCTS, true)
	end
end