--[[
Part of Production Supply Trader FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]

productionSupplyTrader = {}

g_overlayManager:addTextureConfigFile(g_currentModDirectory.."gui/productionSupplyTrader_gui.xml", "productionSupplyTrader")

productionSupplyTrader.PSC = false
local mod = g_modManager:getModByName("FS25_ProductionStorageControl")

--Überprüfen ob PSC geladen wird
if mod ~= nil then
	if g_modIsLoaded[mod.modName] then
		productionSupplyTrader.PSC = true
	end
end


function productionSupplyTrader:onButtonToggleOutputMode(superFunc)
	if g_currentMission:getHasPlayerPermission("manageProductions") then
		local production, productionPoint = self:getSelectedProduction()
		ProductionSettingsDialog.show(function(item) productionPoint:ReceiveSpawnEvent() end, nil, productionPoint:getName(), productionPoint)
	else
		InfoDialog:show(g_i18n:getText("shop_messageNoPermissionGeneral"), nil, nil, DialogElement.TYPE_WARNING)
	end
end

InGameMenuProductionFrame.onButtonToggleOutputMode = Utils.overwrittenFunction(InGameMenuProductionFrame.onButtonToggleOutputMode, productionSupplyTrader.onButtonToggleOutputMode)


function productionSupplyTrader:updateMenuButtons(superFunc)
	if self.PST == nil then
		self.toggleStorageModeButtonInfo.text = g_i18n:getText("productionSupplyTrader_ButtonOpenSetting")
		self.PST = true
	end
end

InGameMenuProductionFrame.updateMenuButtons = Utils.prependedFunction(InGameMenuProductionFrame.updateMenuButtons, productionSupplyTrader.updateMenuButtons)