-- NWT_historyDao
--
-- Data Access Object for tracking farm's net worth history
--

NWT_historyDao = {}
NWT_historyDao.KEY = "history"

function NWT_historyDao:loadFromXMLFile()
  local savegameDir = g_currentMission.missionInfo.savegameDirectory
  if savegameDir ~= nil then
    local xmlPath = savegameDir.."/nwt_history.xml"
    local xmlFile = XMLFile.loadIfExists("nwt_history", xmlPath, NWT_historyDao.KEY)

    if xmlFile ~= nil then
      -- g_farmManager.getFarms() - NPEs, I assume it is not fully loaded
      -- g_farmManager.farmIdToFarm - the ids are wrong?
      -- TODO - figure out how to get farmIds?
      for farmIdIndex = 0, 16 do
        for dayIndex = 0, g_currentMission.environment.currentDay do
          for _, categoryId in pairs(g_nwt_historyManager.categories) do

            local valueKey = NWT_historyDao.KEY
              ..string.format(".farm(%d)", farmIdIndex)
              ..string.format(".day(%d)", dayIndex)
              ..string.format(".%s", categoryId)

            if xmlFile:hasProperty(valueKey) then
              local farmId = xmlFile:getInt(valueKey.."#farmId")
              local dayId = xmlFile:getInt(valueKey.."#dayId")
              local periodId = xmlFile:getInt(valueKey.."#periodId") or 0
              local dayInPeriod = xmlFile:getInt(valueKey.."#dayInPeriod") or 0
              local year = xmlFile:getInt(valueKey.."#year") or 0
              local category = xmlFile:getString(valueKey.."#category") or ""
              local amount = xmlFile:getFloat(valueKey.."#amount") or 0.0

              if farmId ~= nil and dayId ~= nil then
                local valueHistory = NWT_history.new(g_currentMission:getIsServer(), g_currentMission:getIsClient())
                valueHistory:init(farmId, dayId, periodId, dayInPeriod, year, category, amount)
                valueHistory:register()

                table.insert(g_nwt_historyManager.histories, valueHistory)

              end
            end

          end -- end for categories
        end -- end for days
      end -- end for farms

      xmlFile:delete()

    end -- end xml file exists
  end -- end savegame exits

  -- DebugUtil.printTableRecursively(g_nwt_historyManager.histories)

end

function NWT_historyDao:saveToXMLFile()
  local savegameDir = g_currentMission.missionInfo.savegameDirectory
  local xmlPath = savegameDir.."/nwt_history.xml"
  local xmlFile = XMLFile.create("nwt_history", xmlPath, NWT_historyDao.KEY)

  -- DebugUtil.printTableRecursively(g_nwt_historyManager.histories)

  for _, history in g_nwt_historyManager.histories do
    local valueKey = NWT_historyDao.KEY
      ..string.format(".farm(%d)", history.farmId)
      ..string.format(".day(%d)", history.dayId)
      ..string.format(".%s", history.category)

    xmlFile:setInt(valueKey.."#farmId", history.farmId)
    xmlFile:setInt(valueKey.."#dayId", history.dayId)
    xmlFile:setInt(valueKey.."#periodId", history.periodId or 0)
    xmlFile:setInt(valueKey.."#dayInPeriod", history.dayInPeriod or 0)
    xmlFile:setInt(valueKey.."#year", history.year or 0)
    xmlFile:setString(valueKey.."#category", history.category or "")
    xmlFile:setFloat(valueKey.."#amount", history.amount or 0.0)

  end

  xmlFile:save()
  xmlFile:delete()

end

function init()
    Mission00.loadItemsFinished = Utils.appendedFunction(Mission00.loadItemsFinished, NWT_historyDao.loadFromXMLFile)
    FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, NWT_historyDao.saveToXMLFile)
end

init()
